include <gears.scad>

gear_module = 1.0;
gear_bore_diameter = 3.4;

spigot_tooth = 16;
gear_tooth = 25;
ring_tooth = spigot_tooth * 2 + gear_tooth;
ring_rim = 4.0;

gear_clearance = gear_module / 6.0;

spigot_diameter = gear_module * spigot_tooth + (gear_module + gear_clearance) * 2;
gear_diameter = gear_module * gear_tooth + (gear_module + gear_clearance) * 2;
ring_diameter = gear_module * ring_tooth + (gear_module + gear_clearance) * 2;
ring_outer_diameter = ring_diameter + ring_rim * 2;

spigot_center_distance = (spigot_tooth + gear_tooth) / 2;

eps = 0.01;

// Spigot
translate([60, 0, 0]) spur_gear(gear_module, spigot_tooth, 4.0, gear_bore_diameter);

translate([0, 0, 0]) {
    // Ring
    translate([0, 0, 2]) difference() {
        ring_gear(gear_module, ring_tooth, 5.0, ring_rim);
        translate([0, 0, -eps])
            rotate_extrude(angle=180) square([ring_diameter / 2 + 0.1, 5 + eps * 2]);
    }

    // Gear
    translate([0, 0, 2]) {
        rotate(150) difference() {
            spur_gear(gear_module, gear_tooth, 4.0, gear_bore_diameter);
            translate([0, 0, -eps])
                rotate([0, 0, 10]) rotate_extrude(angle=225) {
                    translate([gear_diameter / 2 + 0.1, 0, 0]) square([3.0, 4 + eps * 2]);
                }
        }
    }
    
    difference() {
        cylinder(h=2, r=ring_outer_diameter/2);
        translate([0, 0, -eps]) cylinder(h=2 + eps * 2, r=gear_bore_diameter / 2);
    }
}

// Base and ring hub
translate([0, 60, 0]) {
    difference() {
        union() {
            cylinder(h=2, r=15);
            translate([30, 0, 0]) cylinder(h=9.5, r=15);
            translate([0, -15, 0]) cube([30, 30, 2]);
        }
        translate([0, 0, 2.01]) cylinder(h=7.5, r=ring_outer_diameter / 2 + 1);
        translate([40, 0, 2.01]) cylinder(h=8, r=2.5);
    }
    cylinder(h=7, r=(gear_bore_diameter - 0.1) / 2);
    cylinder(h=3, r=(gear_bore_diameter + 2.5) / 2);
}

// Top piece and spigot hub
translate([0, 100, 0]) {
    cylinder(h=2, r=spigot_diameter / 2);
    translate([10, 0, 0]) cylinder(h=2, r=15);
    translate([40 - spigot_center_distance, 0, 2]) cylinder(h=5, r=2.0);
    
    cylinder(h=7, r=(gear_bore_diameter - 0.1) / 2);
    cylinder(h=3, r=(gear_bore_diameter + 2.5) / 2);
}