import json
import os
import sys

import cgitb
cgitb.enable()

class Webhooks:
    def __init__(self, fp, headers):
        self.fp = fp
        self.headers = headers

    def read_json(self):
        try:
            nbytes = int(self.headers.get("content-length"))
        except (TypeError, ValueError):
            nbytes = 0
        data = self.fp.read(nbytes).decode("utf-8")
        return json.loads(data)

if __name__ == "__main__":
    webhooks = Webhooks(sys.stdin.buffer, os.environ)
    message = webhooks.read_json()
    print(message)