# Rebuilding alsa-ucm-conf

Install the Git packaging tools
```sh
sudo apt install git-buildpackage
```

Clone the maintainers' Git repository
```sh
git clone https://salsa.debian.org/alsa-team/alsa-ucm-conf.git
cd alsa-ucm-conf
```

Add a new patch
```sh
gbp pq import
git revert 7283759a381ca1fc2589da213daa05f9d3b84aac

# Remove changes to some existing patches in the queue (?)
git checkout -- debian/patches/000[123]*

git add debian/patches
dch -i # And edit the Debian changelog message and version number. Replace "ubuntu" with a better name, e.g. "aesthr" :)
git commit -a -m "Closes #1110637"
git tag debian/1.2.14-1aesthr1 # From the changelog
```

Apply the new patch
```sh
gbp pq --force import
git checkout debian/master
gbp buildpackage
```

Install the new package
```sh
sudo dpkg -i ../alsa-ucm-conf_1.2.14-1aesthr1_all.deb
```